<?php

namespace App\Http\Controllers;

use App\Repositories\PaymentMethodRepository;
use App\Repositories\PaymentMethodTypeRepository;
use App\Services\PaymentMethodService;
use Illuminate\Http\Request;

class PaymentMethodController extends Controller
{
    public function __construct(
        private PaymentMethodRepository $repository,
        private PaymentMethodTypeRepository $type,
        private PaymentMethodService $service
    ) {
    
    }
    
    function index(Request $req){
        $type = $this->type->get()[0];
        $params = [
            'title' => 'Metode Pembayaran',
            'collection' => $this->repository->get([
                'type' => $req->type ?? $type->id
            ]),
            'types' => $this->type->get()
        ];
        return view('payment-method.index', $params);
    }

    function edit($id){
        $find = $this->repository->find($id);
    
        if (!$find) {
            return abort(404);
        }
    
        $params = [
            'title' => 'Metode Pembayaran',
            'item' => $find,
            'types' => $this->type->get(),
        ];
        return view('payment-method.edit', $params);
    }

    function update(Request $req){
        return $this->service->container($req, 'update');
    }
    
    function delete(Request $req){
        return $this->service->container($req, 'delete');
    }
}
