<?php

namespace App\Http\Controllers\Product;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Product\PackageService;
use App\Repositories\Product\PackageRepository;

class PackageController extends Controller
{
  public function __construct(
    private PackageRepository $repository,
    private PackageService $service
  ) {
  
  }
  
  function index(Request $req){
    $params = [
      'title' => 'Kemasan Produk',
      'collection' => $this->repository->get($req->all())
    ];
    return view('product.package.index', $params);
  }
  
  function add(){
    $params = [
      'title' => 'Kemasan Produk'
    ];
    return view('product.package.add', $params);
  }
  
  function edit($id){
    $params = [
      'title' => 'Kemasan Produk',
      'item' => $this->repository->find($id),
      'collection' => $this->repository->get()
    ];
    return view('product.package.edit', $params);
  }
  
  function store(Request $req){
    return $this->service->container($req, 'store');
  }
  
  function update(Request $req){
    return $this->service->container($req, 'update');
  }
  
  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }
}
