<?php

namespace App\Http\Controllers\Product;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Product\UnitService;
use App\Repositories\Product\UnitRepository;

class UnitController extends Controller
{
  public function __construct(
    private UnitRepository $repository,
    private UnitService $service
  ) {
  
  }
  
  function index(Request $req){
    $params = [
      'title' => 'Satuan Produk',
      'collection' => $this->repository->get($req->all())
    ];
    return view('product.unit.index', $params);
  }
  
  function add(){
    $params = [
      'title' => 'Satuan Produk'
    ];
    return view('product.unit.add', $params);
  }
  
  function edit($id){
    $params = [
      'title' => 'Satuan Produk',
      'item' => $this->repository->find($id),
      'collection' => $this->repository->get()
    ];
    return view('product.unit.edit', $params);
  }
  
  function store(Request $req){
    return $this->service->container($req, 'store');
  }
  
  function update(Request $req){
    return $this->service->container($req, 'update');
  }
  
  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }
}
