<?php

namespace App\Http\Controllers;

use App\Repositories\PurchaseOrderRepository;
use Illuminate\Http\Request;

class PurchaseOrderController extends Controller
{
    public function __construct(
        private PurchaseOrderRepository $repository,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Purchase Order',
            'collection' => $this->repository->get($req->all())
        ];
        return view('po.index', $params);
    }

    function find($id){
        $find = $this->repository->findWithRelation($id);
    
        if (!$find) {
            return(abort(404));
        }
    
        $params = [
            'title' => 'Purchase Order',
            'item' => $find
        ];
        return view('po.find', $params);
    }
}
