<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\RevenueService;
use Illuminate\Support\Facades\Http;
use App\Repositories\RevenueRepository;
use App\Services\Xendit\XenditService;

class RevenueController extends Controller
{
    public function __construct(
        private RevenueRepository $repository,
        private RevenueService $service,
        private XenditService $xendit,
    ) {
    
    }

    function index(Request $req){
        try {
            $params = [
                'title' => 'WE-HUB Revenue',
                'collection' => $this->repository->get($req->all()),
                'total' => $this->repository->sum('nominal'),
            ];

            return view('revenue.index', $params);
        } catch (\Throwable $th) {
            return abort(500, $th->getMessage());
        }
    }

    function store(Request $req){
        return $this->service->container($req, 'store');
    }

    /**
     * PROFIT
     */

    function profit(Request $req){
        return $this->service->viewUser($req, 'Keuntungan', 'profit');
    }

    /**
     * COST
     */

    function cost(Request $req){
        return $this->service->viewUser($req, 'Biaya Modal', 'cost');
    }

    /**
     * DEPOSITED
     */

     function deposited(Request $req){
        return $this->service->viewUser($req, 'Modal Disetor', 'deposited');
    }

    /**
     * ACTION ON TOP
     */

     
    function storeUser(Request $req){
        return $this->service->container($req, 'storeUser');
    }
}
