<?php

namespace App\Http\Controllers;

use App\Repositories\ShoppingRepository;
use Illuminate\Http\Request;

class ShoppingController extends Controller
{
    public function __construct(
        private ShoppingRepository $repository,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Belanja',
            'collection' => $this->repository->get($req->all())
        ];
        return view('shooping.index', $params);
    }

    function find($id){
        $params = [
            'title' => 'Belanja',
            'item' => $this->repository->findWithRelation($id)
        ];
        return view('shooping.find', $params);
    }
}
