<?php

namespace App\Http\Controllers;

use App\Repositories\SliderRepository;
use App\Services\SliderService;
use Illuminate\Http\Request;

class SliderController extends Controller
{

  public function __construct(
    private SliderRepository $repository,
    private SliderService $service
  ) {

  }

  function index(Request $req){
    $params = [
      'title' => 'Slider',
      'collection' => $this->repository->get($req->all())
    ];
    return view('slider.index', $params);
  }

  function add(){
    $params = [
      'title' => 'Slider'
    ];
    return view('slider.add', $params);
  }

  function edit($id){
    $find = $this->repository->find($id);

    if (!$find) {
      return abort(404);
    }

    $params = [
      'title' => 'Slider',
      'item' => $find,
    ];

    return view('slider.edit', $params);
  }

  function create(Request $req){
    return $this->service->container($req, 'store');
  }

  function update(Request $req){
    return $this->service->container($req, 'update');
  }

  function delete(Request $req){
    return $this->service->container($req, 'delete');
  }
}
