<?php

namespace App\Http\Controllers;

use App\Repositories\SubscriptionRepository;
use App\Services\SubscriptionService;
use Illuminate\Http\Request;

class SubscriptionController extends Controller
{
    public function __construct(
      private SubscriptionRepository $repository,
      private SubscriptionService $service
    ) {
    
    }
    
    function index(Request $req){
      $params = [
        'title' => 'Langganan',
        'collection' => $this->repository->get($req->all())
      ];
      return view('subscription.index', $params);
    }
    
    function add(){
      $params = [
        'title' => 'Langganan'
      ];
      return view('subscription.add', $params);
    }
    
    function edit($id){
      $find = $this->repository->find($id);
    
      if (!$find) {
        return(abort(404));
      }
    
      $params = [
        'title' => 'Langganan',
        'item' => $find
      ];
      return view('subscription.edit', $params);
    }
    
    function store(Request $req){
      return $this->service->container($req, 'store');
    }
    
    function update(Request $req){
      return $this->service->container($req, 'update');
    }
    
    function delete(Request $req){
      return $this->service->container($req, 'delete');
    }
}
