<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\TopUpService;
use App\Repositories\TopUpRepository;
use App\Services\Xendit\XenditService;
use App\Repositories\PaymentMethodTypeRepository;

class TopUpController extends Controller
{
    public function __construct(
        private TopUpRepository $repository,
        private TopUpService $service,
        private XenditService $xendit,
        private PaymentMethodTypeRepository $payment,
    ) {
    
    }

    function index(Request $req){
        $params = [
            'title' => 'WE-HUB Top Up',
            'collection' => $this->repository->get($req->all()),
            'payments' => $this->payment->getWithRelation()->whereNotIn('code', ['withdraw'])->get()
        ];
        return view('top-up.index', $params);
    }

    function proofOfPayment($id){
        $find = $this->repository->findWithRelation($id);

        $params = [
            'title' => 'WE-HUB Top Up',
            'item' => $find
        ];

        return view('top-up.proof-op-payment', $params);
    }

    function store(Request $req){
        return $this->service->container($req, 'store');
    }

    function _proofOfPayment(Request $req){
        return $this->service->container($req, 'proofOfPayment');
    }
}
