<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Authority;
use App\Repositories\UserRepository;
use App\Services\UserService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{

  public function __construct(
    private UserRepository $repository,
    private UserService $service
  ) {
  
  }

  function index(Request $req){
    $params = [
      'title' => 'User Admin',
      'collection' => $this->repository->get($req->all())
    ];

    return view('users.index', $params);
  }

  function add(){
    $params =  [
      'title' => 'User Admin',
      'authority' => Authority::orderBy('title', 'asc')->get()
    ];

    return view('users.add', $params);
  }

  function edit($id){
    $find = $this->repository->notMe($id);

    if (!$find) {
      return abort(404);
    }

    $params = [
      'title' => 'User Admin',
      'authority' => Authority::orderBy('title', 'asc')->get(),
      'find' => $find
    ];

    return view('users.edit', $params);
  }

  function status(Request $req){
    return $this->service->container($req, 'status');
  }

  function create(Request $req){
    return $this->service->container($req, 'store');
  }

  function update(Request $req){
    return $this->service->container($req, 'update');
  }

  function password(Request $req){
    return $this->service->container($req, 'password');
  }
}
