<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Repositories\Vendor\VendorRepository;

class VendorController extends Controller
{
    public function __construct(
        private VendorRepository $repository,
    ) {
    
    }
    
    function index(Request $req){
        $params = [
            'title' => 'Vendor',
            'collection' => $this->repository->get($req->all())
        ];
        return view('vendors.index', $params);
    }

    function find($id){
        $find = $this->repository->findWithRelation($id);

        if (!$find) {
            return abort(404);
        }

        $params = [
            'title' => 'Vendor',
            'item' => $find
        ];
        return view('vendors.find', $params);
    }
   
}
