<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Configuration;
use App\Services\WithdrawSubscribeService;
use App\Repositories\PaymentMethodRepository;
use App\Repositories\WithdrawSubscribeRepository;

class WithdrawSubscribeController extends Controller
{
    public function __construct(
        private PaymentMethodRepository $paymentMethod,
        private WithdrawSubscribeService $service,
        private WithdrawSubscribeRepository $repository,
    ) {
      
    }

    function index(Request $req){
        $params = [
            'title' => 'WE-HUB Langganan',
            'conf' => Configuration::with('bank')->first(),
            'collection' => $this->repository->get($req->all())
        ];
        return view('revenue.subscribe.index', $params);
    }

    function store(Request $req){
        return $this->service->container($req, 'store');
    }

    function otp(Request $req){
        return $this->service->container($req, 'otp');
    }
}
