<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'category';
    
    protected $fillable = ['title', 'type'];

    protected $casts = ['type_as'];

    function getTypeAsAttribute(){
        return $this->type == 'product' ? 'Produk' :
            ($this->type == 'vendor' ? 'Vendor' : 
            ($this->type == 'pengeluaran' ? 'Pengeluaran' : '-'));
    }
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['type'])) {
            $query->where('type', $req['type']);
        }
        if (!empty($req['title'])) {
            $query->where('title', 'LIKE', '%'.$req['title'].'%');
        }
        return $query = $query;
    }
}
