<?php

namespace App\Models\Customer;

use App\Models\Venture\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class Profile extends Model
{
    use HasFactory;

    protected $table = 'customer';

    protected $keyType = 'string';

    protected $appends = ['avatar_image'];

    function getAvatarImageAttribute() {
        return base_url($this->avatar);
    }

    public function scopeWithParameters($query, $req) {
        if (!empty($req['user'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['user'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['user'].'%');
                });
            });
        }
        if (!empty($req['province'])) {
            $query->whereRelation('address.province', 'province_name', 'LIKE', '%'.$req['province'].'%');
        }
        if (!empty($req['city'])) {
            $query->whereRelation('address.city', 'city_name', 'LIKE', '%'.$req['city'].'%');
        }
        if (!empty($req['subdistrict'])) {
            $query->whereRelation('address.subdistrict', 'subdistrict_name', 'LIKE', '%'.$req['subdistrict'].'%');
        }
        if (!empty($req['name'])) {
            $query->where('name', 'LIKE', '%'.$req['name'].'%');
        }
        if (!empty($req['pic'])) {
            $query->where('pic', 'LIKE', '%'.$req['pic'].'%');
        }
        if (!empty($req['role'])) {
            $query->whereRelation('user', 'role', $req['role']);
        }
        return $query = $query;
    }

    function user(){
        return $this->belongsTo(User::class, 'id_user');
    }

    function address(){
        return $this->belongsTo(Address::class, 'id');
    }
}
