<?php

namespace App\Models\Opex\Pengeluaran;

use App\Models\Venture\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class Detail extends Model
{
    use HasFactory;

    protected $table = 'op_pengeluaran';

    protected $keyType = 'string';

    protected $appends = ['purchase_dated'];

    function getPurchaseDatedAttribute() {
        return date('d/m/Y', strtotime($this->purchase_date));
    }
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['created'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['created'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['created'].'%');
                });
            });
        }

        if (!empty($req['start_date'])) {
            $query->whereDate('purchase_date', '>=', $req['start_date']);
        }

        if (!empty($req['end_date'])) {
            $query->whereDate('purchase_date', '<=', $req['end_date']);
        }

        if (!empty($req['role'])) {
            $query->whereRelation('user', 'role', $req['role']);
        }
        return $query = $query;
    }

    function user(){
        return $this->belongsTo(User::class, 'id_user');
    }

    function items(){
        return $this->hasMany(Items::class, 'id_op_pengeluaran');
    }
}
