<?php

namespace App\Models;

use App\Traits\PaymentMethod as TraitsPaymentMethod;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentMethod extends Model
{
    use HasFactory, SoftDeletes, TraitsPaymentMethod;

    protected $table = 'payment_methods';
    
    protected $fillable = [
        'title', 
        'type', 
        'steps', 
        'file', 
        'tax_type',
        'deleted_at',
        'tax'
    ];

    function type_as() {
        return $this->belongsTo(PaymentMethodType::class, 'type')->withTrashed();
    }
}
