<?php

namespace App\Models\PurchaseOrder;

use App\Models\Venture\User;
use App\Models\Customer\Profile;
use App\Models\PurchaseOrder\Item;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Detail extends Model
{
    use HasFactory;

    protected $table = 'po';
    
    protected $keyType = 'string';

    protected $appends = ['purchase_dated', 'payment_dated', 'due_dated'];

    function getPurchaseDatedAttribute() {
        return date('d/m/Y', strtotime($this->purchase_date));
    }

    function getPaymentDatedAttribute() {
        if (!$this->payment_date) {
            return null;
        }
        return date('d/m/Y', strtotime($this->payment_date));
    }

    function getDueDatedAttribute() {
        if (!$this->due_date) {
            return null;
        }
        return date('d/m/Y', strtotime($this->due_date));
    }
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['id'])) {
            $query->where('id', $req['id']);
        }

        if (!empty($req['transaction_type'])) {
            $query->where('transaction_type', $req['transaction_type']);
        }

        if (!empty($req['customer'])) {
            $query->whereRelation('customer', 'name', 'LIKE', '%'.$req['customer'].'%');
        }

        if (!empty($req['created'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['created'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['created'].'%');
                });
            });
        }

        if (!empty($req['start_date'])) {
            $query->whereDate('purchase_date', '>=', $req['start_date']);
        }

        if (!empty($req['end_date'])) {
            $query->whereDate('purchase_date', '<=', $req['end_date']);
        }

        if (!empty($req['start_due_date'])) {
            $query->whereDate('due_date', '>=', $req['start_due_date']);
        }

        if (!empty($req['end_due_date'])) {
            $query->whereDate('due_date', '<=', $req['end_due_date']);
        }

        if (!empty($req['ar'])) {
            $query->whereNull('payment_date');
            $query->whereDate('due_date', '<=', date('Y-m-d', strtotime('+7 days')));
        }
        if (!empty($req['role'])) {
            $query->whereRelation('user', 'role', $req['role']);
        }
        return $query = $query;
    }

    function customer(){
        return $this->belongsTo(Profile::class, 'id_customer');
    }

    function user(){
        return $this->belongsTo(User::class, 'id_user');
    }

    function items(){
        return $this->hasMany(Item::class, 'id_po');
    }
}
