<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subscriptions extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'subscriptions';
    
    protected $fillable = ['title', 'description', 'price', 'duration'];
    
    public function scopeWithParameters($query, $req) {
        if (!empty($req['title'])) {
            $query->where('title', 'like', '%'.$req['title'].'%');
        }
        return $query = $query;
    }
}
