<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use phpDocumentor\Reflection\DocBlock\Tags\Author;

class User extends Authenticatable
{
  use HasApiTokens, HasFactory, Notifiable;

  /**
   * The attributes that are mass assignable.
   *
   * @var array<int, string>
   */
  protected $table = 'admin';
   
  protected $fillable = [
    'name',
    'email',
    'password',
    'authorities_id',
    'active'
  ];

  /**
   * The attributes that should be hidden for serialization.
   *
   * @var array<int, string>
   */
  protected $hidden = [
    'remember_token',
  ];

  /**
   * The attributes that should be cast.
   *
   * @var array<string, string>
   */
  protected $casts = [
    'email_verified_at' => 'datetime',
  ];

  public function scopeWithParameters($query, $req) {
    if (!empty($req['_activity'])) {
      $query->where('active', $req['active'] ?? 'no');
    }
    if (!empty($req['id'])) {
      $query->where('id', $req['id']);
    }
    if (!empty($req['authorities_id'])) {
      $query->where('authorities_id', $req['authorities_id']);
    }
    if (!empty($req['name'])) {
      $query->where('name', 'LIKE', '%'.$req['name'].'%');
    }
    if (!empty($req['authorities'])) {
      $query->whereRelation('authority', 'title', 'LIKE', '%'.$req['authorities'].'%');
    }
    return $query = $query;
  }

  function authority(){
    return $this->belongsTo(Authority::class, 'authorities_id');
  }
}
