<?php

namespace App\Models\Vendor;

use App\Models\Bank;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Account extends Model
{
    use HasFactory;

    protected $table = 'vendor_account';

    protected $keyType = 'string';
    
    protected $fillable = [
        'id', 'bank', 'branch', 'names', 'account_number'
    ];

    function bank_as(){
        return $this->belongsTo(Bank::class, 'bank')->withTrashed();
    }
}
