<?php

namespace App\Models\Venture;

use App\Models\Bank;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Account extends Model
{
    use HasFactory;

    protected $table = 'user_account';
    
    protected $fillable = [
        'id', 'bank', 'branch', 'names', 'account_number'
    ];

    function bank_as(){
        return $this->belongsTo(Bank::class, 'bank')->withTrashed();
    }
}
