<?php

namespace App\Models\Venture;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Approve extends Model
{
    use HasFactory;

    protected $table = 'user_approved';
    
    protected $fillable = ['id', 'id_admin', 'until', 'status'];

    protected $appends = ['expired_at'];

    function getExpiredAtAttribute(){
        return $this->id_admin && $this->until ? tgl($this->until) : 
            ($this->admin ? '-' : null);
    }
    
    function admin(){
        return $this->belongsTo(User::class, 'id_admin');
    }
}
