<?php

namespace App\Models\Venture;

use App\Models\Profession;
use App\Traits\Venture\User as VentureUser;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class User extends Model
{
    use HasFactory, SoftDeletes, VentureUser;

    protected $table = 'users';
    
    protected $fillable = [
        'role', 
        'front_name', 
        'back_name', 
        'nik', 
        'phone_number', 
        'email', 
        'id_profession', 
        'ktp', 
        'npwp', 
        'password', 
        'active', 
        'verified_at', 
        'profile', 
        'pks', 
        'share_portion', 
        'skema',
        'saldo'
    ];

    protected $appends = [
        'name',
        'wehub_portion',
        'active_as'
    ];

    public function account(){
        return $this->belongsTo(Account::class, 'id');
    }

    public function bussines(){
        return $this->belongsTo(Bussines::class, 'id');
    }

    public function approve(){
        return $this->belongsTo(Approve::class, 'id');
    }

    public function subscription(){
        return $this->hasOne(Subscription::class, 'user_id');
    }

    public function profession(){
        return $this->belongsTo(Profession::class, 'id_profession')->withTrashed();
    }
}
