<?php

namespace App\Models\Venture;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class Withdraw extends Model
{
    use HasFactory;

    protected $table = 'user_withdraw';
    
    protected $fillable = ['status', 'description', 'handled_by'];

    protected $casts = [
        'account' => 'json'
    ];

    protected $appends = ['status_html'];

    function getStatusHtmlAttribute() {
        if ($this->status == 'pending') {
            return "<span class='badge badge-warning'>Tertunda</span>";
        } elseif ($this->status == 'accept') {
            return "<span class='badge badge-success'>Disetujui</span>";
        } elseif ($this->status == 'reject') {
            return "<span class='badge badge-danger'>Ditolak</span>";
        }
    }

    public function scopeWithParameters($query, $req) {
        if (!empty($req['status'])) {
            $query->where('status', $req['status']);
        }
        if (!empty($req['user'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'front_name', 'LIKE', '%'.$req['user'].'%');
                })->orWhere(function (Builder $query) use ($req) {
                    $query->whereRelation('user', 'back_name', 'LIKE', '%'.$req['user'].'%');
                });
            });
        }
        return $query = $query;
    }

    function user(){
        return $this->belongsTo(User::class, 'id_user');
    }
}
