<?php

namespace App\Models;

use App\Traits\WithdrawSubscribe as TraitsWithdrawSubscribe;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WithdrawSubscribe extends Model
{
    use HasFactory, TraitsWithdrawSubscribe;

    protected $table = 'admin_withdraw_subscribe';

    protected $fillable = [
        'admin_id',
        'nominal',
        'fee',
        'total',
        'status',
        'account_name',
        'account_number',
        'account_bank',
        'result_json'
    ];

    protected $casts = [
        'result_json' => 'json'
    ];

    function bank(){
        return $this->belongsTo(PaymentMethod::class, 'account_bank')->withTrashed();
    }
}
