<?php

namespace App\Repositories;

use App\Models\Category;

class CategoryRepository {

  function get($req = []){
    $data = Category::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return Category::find($id);
  }

  function count($req = []){
    return Category::withParameters($req)->count();
  }

}