<?php

namespace App\Repositories;

use App\Models\PaymentMethodType;

class PaymentMethodTypeRepository {

  function get($req = []){
    $data = PaymentMethodType::orderBy('id', 'desc')->withParameters($req);
    $result = $data->withTrashed()->get()->map(function($item) {
      return $item;
    });
    return $result;
  }

  function getWithRelation($req = []){
    $data = PaymentMethodType::with('items')->orderBy('id', 'desc');
    return $data;
  }

  function findWithRelation($id){
    return PaymentMethodType::find($id);
  }

  function find($id){
    return PaymentMethodType::find($id);
  }

  function findWithTrashed($id){
    return PaymentMethodType::withTrashed()->find($id);
  }

  function count($req = []){
    return PaymentMethodType::withParameters($req)->count();
  }

}