<?php

namespace App\Repositories;

use App\Models\Profession;

class ProfessionRepository {

  function get($req = []){
    $data = Profession::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function all(){
    return Profession::orderBy('title', 'asc')->get();
  }

  function find($id){
    return Profession::find($id);
  }

  function count($req = []){
    return Profession::withParameters($req)->count();
  }

}