<?php

namespace App\Repositories;

use App\Models\PurchaseOrder\Detail;

class PurchaseOrderRepository {

  function get($req = []){
    $data = Detail::with('user')->withCount('items')
      ->orderBy('created_at', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function ar($req = []){
    $data = Detail::with('user')->withSum('items', 'subtotal')
      ->orderBy('due_date', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Detail::with(['user', 'customer', 'items'])->withSum('items', 'subtotal')->find($id);
  }

  function find($id){
    return Detail::find($id);
  }

  function count(){
    return Detail::count();
  }

}