<?php

namespace App\Repositories;

use App\Models\Slider;

class SliderRepository {
  
  function get($req = []){
    $data = Slider::orderBy('id', 'desc')->withParameters($req);
    $result = $data->get()->map(function($item) {
      return $item;
    });
    return $result;
  }

  function find($id) {
    return Slider::find($id);
  }

  function count(){
    return Slider::orderBy('id', 'desc')->count();
  }

}