<?php

namespace App\Repositories;

use App\Models\Subscriptions;

class SubscriptionRepository {

  function get($req = []){
    $data = Subscriptions::orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function find($id){
    return Subscriptions::find($id);
  }

  function count($req = []){
    return Subscriptions::withParameters($req)->count();
  }

}