<?php

namespace App\Repositories;

use App\Models\TopUp;

class TopUpRepository {
  
  function get($req = []){
    $data = TopUp::with('admin')->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return TopUp::with('admin')->find($id);
  }

  function find($id){
    return TopUp::find($id);
  }

  function sum($field = 'nominal', $req = []){
    return TopUp::withParameters($req)->sum($field);
  }
}