<?php

namespace App\Repositories\Vendor;

use App\Models\Vendor\Account;
use App\Models\Vendor\Address;
use App\Models\Vendor\Profile;

class VendorRepository {

  function get($req = []){
    $data = Profile::with(['user', 'account', 'category', 'address.province', 'address.city', 'address.subdistrict'])->orderBy('id', 'desc')->withParameters($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function findWithRelation($id){
    return Profile::with(['user', 'account.bank_as', 'category', 'address.province', 'address.city', 'address.subdistrict'])->find($id);
  }

  function find($id){
    return Profile::find($id);
  }

  function account($id){
    return Account::find($id);
  }

  function address($id){
    return Address::find($id);
  }

}