<?php

namespace App\Repositories\Venture;

use App\Models\Venture\Bussines;
use App\Models\Venture\Account;
use App\Models\Venture\Approve;
use App\Models\Venture\Saldo;
use App\Models\Venture\User;

class VentureRepository {

  function get($req = []){
    $data = User::with(['subscription.subscription', 'account', 'profession', 'bussines.province', 'bussines.city', 'bussines.subdistrict'])->orderBy('id', 'desc')->filter($req);
    $result = $data->paginate(10)->appends(request()->except('page'));
    $result->getCollection()->transform(function ($item) {
      return $item;
    });
    return $result;
  }

  function search($req = []){
    $data = User::with(['subscription.subscription', 'account', 'profession', 'bussines.province', 'bussines.city', 'bussines.subdistrict'])->orderBy('id', 'desc')->filter($req)->limit(20)->get();
    return $data;
  }

  function findWithRelation($id, $req = []){
    return User::with(['subscription', 'account.bank_as', 'profession', 'bussines.province', 'bussines.city', 'bussines.subdistrict'])->filter($req)->find($id);
  }

  function user($id){
    return User::find($id);
  }

  function account($id){
    return Account::find($id);
  }

  function approve($id){
    return Approve::find($id);
  }

  function saldo($id){
    return Saldo::find($id);
  }

  function bussines($id){
    return Bussines::find($id);
  }

  function count($req = []){
    return User::with('subscription')->filter($req)->count();
  }

}