<?php

namespace App\Services;

use App\Models\Revenue;
use App\Models\WithdrawUser;
use Illuminate\Http\Request;
use App\Services\PartialService;
use App\Services\ValidationService;
use App\Repositories\RevenueRepository;
use App\Repositories\WithdrawUserRepository;

class RevenueService {

  public function __construct(
    private PartialService $partial,
    private RevenueRepository $repository,
    private WithdrawUserRepository $wUser,
    private ValidationService $validation
  ) {
  
  }

  function store(Request $req){
    $this->validation->revenue($req, 'store');

    Revenue::create([
      'nominal' => $req->nominal,
      'date' => $req->date,
      'admin_id' => auth()->user()->id
    ]);

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('revenue')
    ];
  }

  function storeUser(Request $req){
    $this->validation->revenueUser($req, 'store');

    $post = array_merge($req->only(['id_user', 'type', 'date']), [
      'file' => $this->partial->upload($req->file, 'withdraw-user'),
      'handled_by' => auth()->user()->id,
      'nominal' => preg_replace('/[^0-9]/', '', $req->nominal)
    ]);

    WithdrawUser::create($post);

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('revenue/'.$req->type),
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'storeUser') {
        $e = $this->storeUser($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

  function viewUser(Request $req, $title, $type){
    $params = [
      'title' => $title,
      'type' => $type,
      'collection' => $this->wUser->get([
        'type' => $type,
        'start_date' => $req->start_date,
        'end_date' => $req->end_date,
        'user' => $req->user,
        'admin' => $req->admin,
      ])
    ];

    return view('revenue.user.index', $params);
  }
}