<?php

namespace App\Services;

use App\Models\Slider;
use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Repositories\SliderRepository;

class SliderService {

  public function __construct(
    private SliderRepository $repository,
    private PartialService $partial,
    private ValidationService $validation
  ) {
    
  }

  function store(Request $req){
    $this->validation->slider($req, 'store');

    $get = Slider::orderBy('urutan', 'desc')->first();
    $urutan = ($get) ? $get->urutan + 1 : 1;

    Slider::create(array_merge($req->only('url'), [
      'file' => $this->partial->upload($req->file, 'slider'),
      'id_admin' => auth()->user()->id,
      'urutan' => $urutan,
      'active' => 'no'
    ]));

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('sliders')
    ];
  }

  function update(Request $req){
    $this->validation->slider($req, 'update');

    $data = $this->repository->find($req->id);

    if ($req->file) {
      $this->partial->deleteFile($data->file);
    }

    if ($req->id != $req->urutan) {
      $find = $this->repository->find($req->urutan);
      $find_change = [
        'urutan' => $data->urutan
      ];
      $urutan = $find->urutan;
    } else {
      $urutan = $data->urutan;
    }

    $data->update(array_merge($req->only('url'), [
      'file' => $req->file ? $this->partial->upload($req->file, 'slider') : $data->file,
      'active' => ($req->active == 'yes') ? 'yes' : 'no',
      'urutan' => $urutan
    ]));

    if ($req->id != $req->urutan) {
      $find->update($find_change);
    }

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('sliders')
    ];
  }

  function delete(Request $req){
    $data = $this->repository->find($req->id);

    if (!$data) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 500);
    }

    $this->partial->deleteFile($data->file);

  
    $data->delete();

    return [
      'message' => config('message.DELETE_SUCCESS'),
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'delete') {
        $e = $this->delete($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}