<?php

namespace App\Services;

use App\Models\Subscriptions;
use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\PartialService;
use App\Services\ValidationService;
use App\Repositories\SubscriptionRepository;

class SubscriptionService {

  public function __construct(
    private PartialService $partial,
    private SubscriptionRepository $repository,
    private ValidationService $validation
  ) {
  
  }

  function store(Request $req){
    $this->validation->subscription($req, 'store');

    Subscriptions::create($req->only([
      'title', 'description', 'price', 'duration'
    ]));

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('subscriptions')
    ];
  }

  function update(Request $req){
    $this->validation->subscription($req, 'update');

    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $find->update($req->only([
      'title', 'description', 'price', 'duration'
    ]));

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('subscriptions')
    ];
  }

  function delete(Request $req){
    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 404);
    }

    $find->delete();

    return [
      'message' => config('message.DELETE_SUCCESS'),
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'delete') {
        $e = $this->delete($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}