<?php

namespace App\Services;

use App\Models\TopUp;
use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\PartialService;
use Illuminate\Support\Facades\DB;
use App\Services\ValidationService;
use App\Repositories\TopUpRepository;
use App\Services\Xendit\XenditService;
use App\Repositories\PaymentMethodRepository;

class TopUpService {

  public function __construct(
    private PartialService $partial,
    private TopUpRepository $repository,
    private ValidationService $validation,
    private XenditService $xendit,
    private PaymentMethodRepository $payment
  ) {
  
  }

  function store(Request $req){
    $this->validation->topup($req, 'store');

    $payment = $this->payment->findWithRelation($req->payment);
    $payment = [
      'id' => $payment->id,
      'code' => $payment->code,
      'title' => $payment->title,
      'tax' => $payment->tax,
      'type' => $payment->type_as->code,
      'tax_type' => $payment->tax_type,
      'file' => base_url($payment->file)
    ];

    $code = 'TOPUP_'.rand(0000000, 9999999);

    $create = TopUp::create([
      'external_id' => $code,
      'nominal' => $req->nominal,
      'date' => $req->date,
      'admin_id' => auth()->user()->id,
      'payment' => $payment,
      'date' => date('Y-m-d'),
      // 'proof_of_payment' => $this->partial->upload($req->file, 'proof_of_payment')
      'proof_of_payment' => null
    ]);

    $xendit = $this->xendit->send($payment['type'], $payment['code'], $req->nominal, $code);

    $find = TopUp::find($create->id)->update([
      'response' => $xendit
    ]);

    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('top-up')
    ];
  }

  function proofOfPayment(Request $req){
    $this->validation->topup($req, 'proofOfPayment');
   
    $find = $this->repository->find($req->id);
    
    if (!$find) {
      throw new InvalidArgumentException('Data tidak ditemukan!', 500);
    }

    $find->update([
      'proof_of_payment' => $this->partial->upload($req->file, 'proof_of_payment')
    ]);

    return [
      'message' => config('message.UPDATE_SUCCESS'),
      'url' => url('top-up')
    ];
  }

  function container(Request $req, $action){
    DB::beginTransaction();

    try {
      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'proofOfPayment') {
        $e = $this->proofOfPayment($req);
      }

      DB::commit();

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      DB::rollBack();

      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}