<?php

namespace App\Services;

use App\Models\User;
use Illuminate\Http\Request;
use InvalidArgumentException;
use App\Services\ValidationService;
use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Hash;

class UserService {

  public function __construct(
    private UserRepository $repository,
    private ValidationService $validation
  ) {
    
  }

  function status(Request $req){
    $this->validation->user($req, 'status');

    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 500);
    }
    
    $find->update([
      'active' => $find->active == 'yes' ? 'no' : 'yes'
    ]);

    return [
      'active' => $find->active == 'yes' ? 1 : 0
    ];
  }

  function store(Request $req){
    $this->validation->user($req, 'store');

    User::create(array_merge($req->only(['authorities_id', 'name', 'email']), [
      'password' => Hash::make($req->password),
      'active' => 1
    ]));
    
    return [
      'message' => config('message.ADD_SUCCESS'),
      'url' => url('users')
    ];
  }

  function update(Request $req){
    $this->validation->user($req, 'update');

    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 500);
    }

    $find->update($req->only([
      'authorities_id', 'name', 'email'
    ]));

    if ($req->id == auth()->user()->id) {
      $ext = [
        'message' => 'Profile berhasil diubah.'
      ];
    } else {
      $ext = [
        'url' => url('users')
      ];
    }
    return array_merge([
      'message' => config('message.UPDATE_SUCCESS'),
    ], $ext);
  }

  function password(Request $req){
    $this->validation->user($req, 'password');

    $find = $this->repository->find($req->id);

    if (!$find) {
      throw new InvalidArgumentException(config('message.DATA_NOT_FOUND'), 500);
    }

    $find->update([
      'password' => Hash::make($req->password)
    ]);

    return [
      'message' => 'Password berhasil diubah.'
    ];
  }

  function container(Request $req, $action){
    try {

      if ($action == 'status') {
        $e = $this->status($req);
      } elseif ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'update') {
        $e = $this->update($req);
      } elseif ($action == 'password') {
        $e = $this->password($req);
      }

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }
  
}