<?php

namespace App\Services;

use Illuminate\Http\Request;
use InvalidArgumentException;
use Illuminate\Support\Facades\Validator;

class ValidationService
{ 
  function withdrawSubscribe(Request $req){
    $rules = [
      'nominal' => 'required',
      'otp' => 'required'
    ];

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }

  }

  function slider(Request $req, $action){
    if ($action == 'store') { # STORE VALIDATION
      $rules = [
        'file' => 'required|image|max:2228'
      ];
    } elseif ($action == 'update') { # UPDATE VALIDATION
      $rules = [
        'id' => 'required',
        'file' => 'image|max:2228'
      ];
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }

  }

  function authority(Request $req, $action){
    $rules = [
      'title' => 'required',
      'code' => 'required'
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required'
      ]);
    }

    $messages = [
      'code.required' => 'Wajib memilih fitur setidaknya 1'
    ];

    $validator = Validator::make($req->all(), $rules, $messages);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function user(Request $req, $action){
    if ($action == 'status') { # STATUS VALIDATION
      $params = [
        'id' => 'required'
      ];
    } elseif ($action == 'store') { # STORE VALIDATION
      $params = [
        'authorities_id' => 'required',
        'name' => 'required',
        'email' => 'required|unique:admin,email|email',
        'password' => 'required',
      ];
    } elseif ($action == 'update') { # UPDATE VALIDATION
      $params = [
        'authorities_id' => 'required',
        'name' => 'required',
        'id' => 'required|numeric',
        'email' => 'required|email|unique:admin,email,'.$req->id,
      ];
    } elseif ($action == 'password') { # PASSWORD VALIDATION
      $params = [
        'password' => 'required|confirmed|min:8|max:30',
        'id' => 'required|numeric',
      ];
    }

    $validator = Validator::make($req->all(), $params);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function profile(Request $req, $action){
    if ($action == 'update') {
      $rules = [
        'email' => 'required|unique:admin,email,'.auth()->user()->id,
        'name' => 'required',
      ];
    } elseif ($action == 'password') {
      $rules = [
        'password' => 'required|confirmed|min:8|max:30',
        'curr_password' => 'required',
      ];
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function bank(Request $req, $action){
    if ($action == 'store') { # STORE VALIDATION
      $rules = [
        'name' => 'required',
        // 'file' => 'required|image|max:2228'
      ];
    } elseif ($action == 'update') { # UPDATE VALIDATION
      $rules = [
        'id' => 'required',
        'name' => 'required',
        // 'file' => 'image|max:2228'
      ];
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function revenue(Request $req, $action){
    $rules = [
      'nominal' => 'required',
      'date' => 'required',
    ];

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function revenueUser(Request $req, $action){
    $rules = [
      'nominal' => 'required',
      'date' => 'required',
      'id_user' => 'required',
      'file' => 'required',
    ];

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function topup(Request $req, $action){
    if ($action == 'store') { # STORE VALIDATION
      $rules = [
        'nominal' => 'required',
      ];
    } elseif ($action == 'proofOfPayment') {
      $rules = [
        'file' => 'required|image|max:3228'
      ];
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function profession(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'title' => 'required',
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function branch(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'title' => 'required',
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function subscription(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'title' => 'required',
      'description' => 'required',
      'price' => 'required',
      'duration' => 'required',
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }
  
  function category(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'title' => 'required',
      'type' => 'required'
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function productUnit(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'title' => 'required',
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function productPackage(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'title' => 'required',
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }
  
  function product(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'id_category_product' => 'required',
      'title' => 'required',
      'id_unit_product' => 'required',
      'id_package_product' => 'required',
    ];

    if ($action == 'update') { # UPDATE VALIDATION
      $rules = array_merge($rules, [
        'id' => 'required',
      ]);
    }

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function wallet(Request $req, $action){
    $rules = [ # STORE VALIDATION
      'user_id' => 'required',
      'setor' => 'required',
      'modal' => 'required',
      'file' => 'max:12228',
    ];

    $validator = Validator::make($req->all(), $rules);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }

  function venture(Request $req, $action){
    $params = [
      'front_name' => 'required',
      'back_name' => 'required',
      'nik' => 'required',
      'id_profession' => 'required',
      'npwp' => 'image|max:2228',
      'bank' => 'required',
      'branch' => 'required',
      'account_name' => 'required',
      'account_number' => 'required',
      'name_bussines' => 'required',
      'id_province' => 'required',
      'id_city' => 'required',
      'id_subdistrict' => 'required',
      'village' => 'required',
      'postcode' => 'required',
      'address' => 'required',
      'latitude' => 'required',
      'longitude' => 'required',
      'akta' => 'image|max:2228',
      'npwp_bussines' => 'image|max:2228',
      'nib' => 'image|max:2228',
      'sk_kemenkum' => 'image|max:2228',
    ];

    if ($action == 'store') { # STORE VALIDATION
      $params = array_merge($params, [
        'email' => 'required|unique:users,email|email',
        'phone_number' => 'required|unique:users,phone_number',
        'password' => 'required',
        'ktp' => 'required|image|max:2228',
        'profile' => 'required|image|max:2228'
      ]);
    } elseif ($action == 'update') { # UPDATE VALIDATION
      $params = array_merge($params, [
        'id' => 'required',
        'email' => 'required|email|unique:users,email,'.$req->id,
        'phone_number' => 'required|unique:users,phone_number,'.$req->id,
        'ktp' => 'image|max:2228',
        'profile' => 'image|max:2228'
      ]);
    }

    $validator = Validator::make($req->all(), $params);

    if ($validator->fails()) {
      throw new InvalidArgumentException($validator->errors()->first(), 422);
    }
  }
}
