<?php

namespace App\Services;

use App\Mail\OtpWithdraw;
use Illuminate\Http\Request;
use App\Models\Configuration;
use InvalidArgumentException;
use App\Services\Xendit\XenditService;
use App\Services\Xendit\Payout;
use App\Models\WithdrawSubscribe;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class WithdrawSubscribeService {

  public function __construct(
    private ValidationService $validation,
    private XenditService $xendit,
    private Payout $payout,
  ) {
    
  }

  function store(Request $req){
    $this->validation->withdrawSubscribe($req);

    $conf = Configuration::with('bank')->first();

    if (!Hash::check($req->otp, $conf->otp_withdraw)) {
      throw new InvalidArgumentException('Kode OTP salah!', 500);
    }

    $balance = $this->xendit->getBalance();
    // $balance = $balance['balance'] - 50000;

    $nominal = preg_replace('/[^0-9]/', '', $req->nominal);

    if ($nominal > $balance) {
      throw new InvalidArgumentException('Saldo tidak cukup!', 500);
    }

    $fee = $conf->bank->tax;
    if($conf->bank->tax_type == 'percent') {
      $fee = $nominal * ($fee / 100);
    }

    $total = $fee + $nominal;

    $post = [
      'admin_id' => auth()->user()->id,
      'nominal' => $nominal,
      'total' => $nominal,
      'fee' => 0,
      'account_name' => $conf->account_name,
      'account_number' => $conf->account_number,
      'account_bank' => $conf->account_bank,
      'result_json' => null
    ];
    
    $create = WithdrawSubscribe::create($post);

    $xendit = $this->payout->store($conf->bank->code, $conf->account_number, $conf->account_name, $nominal);

    WithdrawSubscribe::find($create->id)->update([
      'result_json' => $xendit
    ]);

    $updateconf = $conf->update([
      'otp_withdraw' => null
    ]);
    
    return [
      'message' => 'Berhasil melakukan penarikan!',
      'url' => url('revenue/subscription')
    ];
  }

  function otp(Request $req){
    $otp = rand(000000, 999999);

    $conf = Configuration::first();

    $update = $conf->update([
      'otp_withdraw' => Hash::make($otp)
    ]);

    Mail::to($conf->email_getotp)->send(new OtpWithdraw($otp));

    return [
      'otp' => $otp
    ];
  }

  function container(Request $req, $action){
    DB::beginTransaction();

    try {
      if ($action == 'store') {
        $e = $this->store($req);
      } elseif ($action == 'otp') {
        $e = $this->otp($req);
      }

      DB::commit();

      return response()->json(array_merge($e, [
        'code' => 200,
        'success' => true,
      ]));
    } catch (\Throwable $th) {
      DB::rollBack();

      return response()->json([
        'code' => 500,
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}