<?php

namespace App\Services\Xendit;

use App\Repositories\WithdrawSubscribeRepository;
use Illuminate\Http\Request;
use InvalidArgumentException;

class Notification {

  public function __construct(
    private WithdrawSubscribeRepository $withdraw
  ) {
  
  }

  public function payout(Request $request)
  {
    try {
      $id     = $request->input('id');
      $amount = $request->input('amount');

      $find = $this->withdraw->findByJsonAndAmount('result_json->id', $id, $amount);
      if (!$find) {
        throw new InvalidArgumentException('Withdraw tidak ditemukan!', 500);
      }

      $update = $find->update([
        'status' => 'success',
        'result_json' => $request->all()
      ]);

      return response()->json([
        'code' => 200,
        'success' => true
      ]);
    } catch (\Throwable $th) {
      return response()->json([
        'success' => false,
        'message' => $th->getMessage()
      ], 500);
    }
  }

}