<?php

namespace App\Services\Xendit;

use Xendit\Xendit;
use Xendit\Balance;

class XenditService {

  public function __construct(
    private VirtualAccount $va,
    private CStore $cstore,
    private EWallet $ewallet,
  ) {
    Xendit::setApiKey(env('XENDIT_PRODUCTION') ? env('XENDIT_KEY_PROD') : env('XENDIT_KEY_DEV'));
  }

  function getBalance($type = 'CASH'){
    /**
     * AVAILABLE TYPES: 
     * CASH, TAX, HOLDING
     */
    return Balance::getBalance($type);
  }

  function send($payment_method_type, $payment_method, $nominal, $external_id)
  {
    switch ($payment_method_type) {
      case 'transfer_va':
        $result_json = $this->virtualAccount($payment_method, $nominal, $external_id);
        break;
      case 'cstore':
        $result_json = $this->cstore($payment_method, $nominal, $external_id);
        break;
      case 'emoney':
        $result_json = $this->ewallet($payment_method, $nominal, $external_id);
        break;
      default:
        $result_json = [];
        break;
    }

    return $result_json;
  }


  private function virtualAccount(string $bank_code, int $total, string $external_id) {
    $user_va = $this->va->findAccount($bank_code, $external_id, $total);

    if (!$user_va['new'] && $user_va['e']['va_response']['is_closed']) {
      return $this->va->updateExceptedAmount($user_va['e']->va_id, $total)['va_response'];
    }

    return $user_va['e']['va_response'];
  }

  private function cstore(string $type, int $total, string $external_id) {
    $user_va = $this->cstore->findAccount($type, $total, $external_id);

    $update_va = $this->cstore->updateExceptedAmount($user_va['va_id'], $total);

    return $update_va['va_response'];
  }

  private function ewallet(string $type, int $total, string $external_id)
  {
    switch ($type) {
      case 'ID_OVO':
        return $this->ewallet->ovo($total, $external_id);
        break;
      case 'ID_DANA':
        // return $this->ewallet->dana($total, $external_id);
        break;
      case 'ID_SHOPEEPAY':
        // return $this->ewallet->shoppe($total, $external_id);
        break;
      default:
        return [];
      break;
    }
  }

}