<?php

namespace App\Traits\Venture;

use Illuminate\Database\Eloquent\Builder;

trait User
{
    function getWehubPortionAttribute() {
        return 100 - $this->share_portion;
    }

    function getNameAttribute() {
        return $this->front_name.' '.$this->back_name;
    }
    
    function getActiveAsAttribute() {
        if ($this->active == 'yes') {
            return 'Aktif';
        } elseif ($this->active == 'banned') {
            return 'Diblokir';
        } else {
            return 'Tidak Aktif';
        }
    }

    public function scopeFilter($query, $req) {
        if (!empty($req['name'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $words = explode(' ', $req['name']);
                    foreach($words as $key => $word){
                        if($key < 1) {
                            $query->where('front_name', 'LIKE', '%'.$word.'%');
                        } else {
                            $query->orWhere('front_name', 'LIKE', '%'.$word.'%');
                        }
                    }
                })->orWhere(function (Builder $query) use ($req) {
                    $words = explode(' ', $req['name']);
                    foreach($words as $key => $word){
                        if($key < 1) {
                            $query->where('back_name', 'LIKE', '%'.$word.'%');
                        } else {
                            $query->orWhere('back_name', 'LIKE', '%'.$word.'%');
                        }
                    }
                });
            });
        }
        
        if (!empty($req['bussines_name'])) {
            $query->whereRelation('bussines', 'name_bussines', 'LIKE', '%'.$req['bussines_name'].'%');
        }
        
        if (!empty($req['role'])) {
            $query->where('role', $req['role']);
        }

        if (!empty($req['not_approved'])) {
            $query->whereRelation('approve', 'id_admin', null);
        }

        if (!empty($req['subscribe'])) {
            $query->whereRelation('subscription', 'expired_at', '>', date('Y-m-d'));
        }

        if (!empty($req['unsubscribe'])) {
            $query->where(function (Builder $query) use ($req) {
                $query->where(function (Builder $query) use ($req) {
                    $query->whereRelation('subscription', 'expired_at', '<', date('Y-m-d'));
                })->orWhere(function (Builder $query) use ($req) {
                    $query->doesntHave('subscription');
                });
            });
        }
        
        return $query = $query;
    }
}