<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Builder;

trait WithdrawSubscribe
{
    public function scopeFilter($query, $req) {
        if (!empty($req['start_date'])) {
            $query->whereDate('created_at', '>=', $req['start_date']);
        }
        if (!empty($req['end_date'])) {
            $query->whereDate('created_at', '<=', $req['end_date']);
        }
        if (!empty($req['an'])) {
            $query->where('account_name', 'LIKE', '%'.$req['an'].'%');
        }
        if (!empty($req['bank'])) {
            $query->whereRelation('bank', 'title', 'LIKE', '%'.$req['bank'].'%');
        }
        return $query = $query;
    }
}
