<x-layout title="Otoritas Fitur">
  
  <x-breadcrumb 
    title="Otoritas Fitur" 
    :items="[
      ['Otoritas Fitur']
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-partial.button-add 
        class="col-12 mb-3"
        href="authority/add" />

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Nama</th>
              <th>Jumlah Akses yang dizinkan</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering w-10px">{{no($key)}}</td>
                <td>{{$item->title}}</td>
                <td>{{$item->features_count}} fitur</td>
                <td id="action-{{$item->id}}">
                  <x-partial.button-edit href="authority/edit/{{$item->id}}" />
              
                  <x-partial.button-delete
                    action="authority/_delete"
                    id="{{$item->id}}" />
                </td>
              </tr>
            @endforeach
          </tbody>
          <x-slot name="extra">
            {{$collection->links('vendor.pagination.simple-bootstrap-4')}}
          </x-slot>
        </x-partial.table-content>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/delete.js')}}" 
      element="table"></script>
  </x-slot>

</x-layout>
