<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-partial.button-add 
        class="col-md-2 col-12 mb-3"
        href="banks/add" />

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Nama Bank</th>
              <th class="w-300px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering">{{no($key)}}</td>
                <td>{{$item->name}}</td>
                <td id="action-{{$item->id}}">
                  <x-partial.button-edit href="banks/edit/{{$item->id}}" />

                  <x-partial.button-delete
                    action="banks/_delete"
                    id="{{$item->id}}" />
                </td>
              </tr>
            @endforeach
          </tbody>
        </x-partial.table-content>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/delete.js')}}" 
      element="table"></script>
  </x-slot>

</x-layout>