<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('categories')],
      ['Edit']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Edit {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('categories/_update')}}" 
        method="post">
        <div class="card-body">
          <input type="hidden" name="id" value="{{$item->id}}" />
          <div class="row">
            <x-form.input 
              div="col-md-8"
              label="Nama" name="title" 
              value="{{$item->title}}"
              placeholder="Masukan nama kategori" />
          <x-form.select 
              div="col-md-4" 
              value="{{$item->type}}"
              label="Tipe" name="type" 
              :collection="config('select.CATEGORY_TYPE')"
              :option="['id', ['text']]" />
          </div>
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>