<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  
  <title>{{$title}} | {{$configuration->title}}</title>

  {{-- FAVICON --}}
  <link 
    rel="alternate icon" 
    class="js-site-favicon" 
    type="image/png" 
    href="{{_asset('img/logo/logo.png')}}" />
  <link 
    rel="icon" 
    class="js-site-favicon" 
    type="image/svg+xml" 
    href="{{_asset('img/logo/logo.png')}}" />
  <link 
    rel="stylesheet" 
    href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback" />
  
  {{-- CSS --}}
  <link 
    rel="stylesheet" 
    type="text/css" 
    href="{{_asset('dist/css/adminlte.min.css')}}" />
  <link 
    rel="stylesheet" 
    type="text/css" 
    href="{{_asset('plugins/sweetalert2/sweetalert2.min.css')}}" />
  <link 
    rel="stylesheet" 
    type="text/css" 
    href="{{_asset('dist/css/custom.css?ls=wereqr223wrtwesdfs')}}" />

  {{-- SLOT CSS --}}
  @stack('css')

  @if (isset($css))
    {{ $css }}
  @endif

</head>
<body class="hold-transition sidebar-mini">
  <div class="wrapper">
    <x-navbar />  

    <x-sidebar.content :configuration="$configuration" />  

    <div class="content-wrapper">
      {{$slot}}
      <div class="pb-1"></div>
    </div>

    <x-footer />  
  </div>

  {{-- JS LIBRARY --}}
  <script 
    type="text/javascript" 
    src="{{_asset('plugins/jquery/jquery.min.js')}}"></script>
  <script 
    type="text/javascript" 
    src="{{_asset('plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
  <script 
    type="text/javascript" 
    src="{{_asset('dist/js/adminlte.min.js')}}"></script>
  <script 
    type="text/javascript" 
    src="{{_asset('plugins/sweetalert2/sweetalert2.min.js')}}"></script>
  <script 
    src="https://kit.fontawesome.com/6e7d570307.js" 
    crossorigin="anonymous"></script>
  
  {{-- JS CUSTOM --}}
  <script 
    type="text/javascript" src="{{_asset('js/all.js?ls=3456789gh')}}"></script>
  <script>
    const prefixURL = "{{url('')}}"
  </script>

  {{-- SLOT JS --}}
  @stack('js')

  @if (isset($js))
    {{ $js }}
  @endif
</body>
</html>
