<form 
class="_form" 
action="{{url($action)}}" 
method="post">
  <div class="card-body">
    <input type="hidden" name="id" value="{{$item?->id ?? ''}}" />
    <x-form.select
    label="Role" name="role"
    value="{{$_GET['role'] ?? ''}}"
    :collection="[
      [ 'id' => 'Mitra Kerjasama' ],
      [ 'id' => 'Mitra Mandiri' ]
    ]"
    :option="['id', ['id']]" />
    {{-- PROFILE --}}
    <h5 class="text-bold mt-4 mb-3">PROFILE</h5>
    
    @if(!empty($item?->profile))
      <x-form.image 
        required="off" value="{{$item->profile}}"
        label="Foto Profile" name="profile"
        id="file" />
    @else 
      <x-form.image 
        label="Foto Profile" name="profile"
        id="file" />
    @endif

    <div class="row">
      <x-form.select
        div="col-md-4" class="select2"
        label="Profesi" name="id_profession" value="{{$item?->id_profession ?? ''}}"
        :collection="$professions" :option="['id', ['title']]" />
      <x-form.input
        div="col-md-4" value="{{$item?->front_name ?? ''}}"
        label="Nama Depan" name="front_name" 
        placeholder="Masukan nama depan" />
      <x-form.input
        div="col-md-4" value="{{$item?->back_name ?? ''}}"
        label="Nama Belakang" name="back_name" 
        placeholder="Masukan nama belakang" />
      <x-form.input
        div="col-md-4" value="{{$item?->nik ?? ''}}"
        label="NIK" placeholder="Masukan NIK"
        name="nik" type="number" />
      <x-form.input
        div="col-md-4" placeholder="Masukan no. handphone"
        label="No. Handphone" value="{{$item?->phone_number ?? ''}}"
        name="phone_number" type="number" />
      <x-form.input
        div="col-md-4" value="{{$item?->email ?? ''}}"
        label="Email" placeholder="Masukan email"
        name="email" type="email" />
      <x-form.input
        div="col-md-6" offrequired
        type="password" name="password" 
        label="Password" placeholder="{{$item ? 'Ganti password jika ingin' : 'Masukan password'}}" />
    </div>
    <div class="row">
      @if(!empty($item?->ktp))
        <x-form.image 
          required="off"
          label="KTP" name="ktp" value="{{$item->ktp}}"
          id="file2" div="col-md-6" />
      @else 
        <x-form.image 
          label="KTP" name="ktp"
          id="file2" div="col-md-6" />
      @endif
      <x-form.image 
        label="NPWP (optional)" name="npwp" value="{{$item?->npwp ?? ''}}"
        id="file3" div="col-md-6" required="off" />
    </div>
    {{-- PROFILE USAHA --}}
    <h5 class="text-bold mt-3 mb-3">PROFILE USAHA</h5>
    <x-form.image 
      @if ($item?->bussines?->profile_bussines ?? '') required="off" @endif
      label="Foto Usaha" name="profile_bussines"
      id="file4" value="{{$item?->bussines?->profile_bussines ?? ''}}" />
    <div class="row">
      <x-form.input
        div="col-md-6" group="by {{$configuration->title}}"
        label="Nama Usaha" name="name_bussines" 
        placeholder="Masukan nama usaha"
        value="{{$item?->bussines?->name_bussines ?? ''}}" />
      <x-form.select 
        div="col-md-6" class="select2" id="id_province"
        name="id_province" :option="['province_id', ['province_name']]"
        :collection="$provinces" label="Provinsi"
        value="{{$item?->bussines?->id_province ?? ''}}" />
      <x-form.select 
        div="col-md-6" class="select2" id="id_city"
        name="id_city" :option="['city_id', ['city_name']]"
        :collection="[]" label="Kota / Kabupaten" />
      <x-form.select 
        div="col-md-6" class="select2" id="id_subdistrict"
        name="id_subdistrict" :option="['subdistrict_id', ['subdistrict_name']]"
        :collection="[]" label="Kecamatan" />
      <x-form.input
        div="col-md-6" value="{{$item?->bussines?->village ?? ''}}"
        label="Desa / Kelurahan" name="village" 
        placeholder="Masukan desa / kelurahan" />
      <x-form.input
        div="col-md-6" value="{{$item?->bussines?->postcode ?? ''}}"
        label="Kode POS" name="postcode" 
        placeholder="Masukan kode POS" />
      <x-form.input
        div="col-md-12" value="{{$item?->bussines?->address ?? ''}}"
        label="Alamat Lengkap" name="address" 
        placeholder="Masukan Alamat Lengkap" />
      <x-form.input
        div="col-md-6" value="{{$item?->bussines?->latitude ?? ''}}"
        label="Latitude" name="latitude" 
        placeholder="Masukan latitude" />
      <x-form.input
        div="col-md-6" value="{{$item?->bussines?->longitude ?? ''}}"
        label="Longitude" name="longitude" 
        placeholder="Masukan longitude" />
    </div>
    <div class="row">
      <x-form.image 
        label="Akta (optional)" name="akta"
        id="file5" div="col-md-3" required="off"
        value="{{$item?->bussines?->akta ?? ''}}" />
      <x-form.image 
        label="NPWP (optional)" name="npwp_bussines"
        id="file6" div="col-md-3" required="off"
        value="{{$item?->bussines?->npwp_bussines ?? ''}}" />
      <x-form.image 
        label="NIB (optional)" name="nib"
        id="file7" div="col-md-3" required="off"
        value="{{$item?->bussines?->nib ?? ''}}" />
      <x-form.image 
        label="SK Kemenkum (optional)" name="sk_kemenkum"
        id="file8" div="col-md-3" required="off"
        value="{{$item?->bussines?->sk_kemenkum ?? ''}}" />
    </div>
    {{-- AKUN BANK --}}
    <h5 class="text-bold mt-3 mb-3">AKUN BANK</h5>
    <div class="row">
      <x-form.select
        div="col-md-6" class="select2"
        label="Bank" name="bank" value="{{$item?->account?->bank ?? ''}}"
        :collection="$banks" :option="['id', ['name']]" />
      <x-form.input
        div="col-md-6" placeholder="Masukan cabang"
        label="Cabang" name="branch"
        value="{{$item?->account?->branch ?? ''}}" />
      <x-form.input
        div="col-md-6" name="account_name"
        label="Nama Rekening" placeholder="Masukan nama rekening"
        value="{{$item?->account?->names ?? ''}}" />
      <x-form.input
        div="col-md-6" placeholder="Masukan no. rekening"
        label="No. Rekening" name="account_number"
        value="{{$item?->account?->account_number ?? ''}}" />
    </div>
  </div>
  <div class="card-footer">
    <a 
      onclick="return history.go(-1)" 
      class="btn btn-default" 
      id="_backButton">Kembali</a>
    <button 
      type="submit" 
      class="btn btn-primary" 
      id="_button">Simpan</button>
  </div>
</form>

@push('js')
<script 
  type="text/javascript" 
  province="{{$item?->bussines?->id_province ?? ''}}"
  city="{{$item?->bussines?->id_city ?? ''}}"
  subdistrict="{{$item?->bussines?->id_subdistrict ?? ''}}"
  src="{{_asset('js/area.js?ls=25071640')}}"></script>
@endpush